import moment, {Moment} from 'moment';

/**
 * Вычесляет moment к которому подскролить календарь
 */
export default function getScrolledMoment(
    startDate: Date | undefined,
    endDate: Date | undefined,
    nowDate: Date,
    minDate: Date,
): Moment | undefined {
    const scrolledDate = startDate || endDate || nowDate;
    const scrolledMoment = moment(scrolledDate);
    const minMoment = moment(minDate);

    const minMomentStartOfMonth = moment(minMoment.toDate()).startOf('month');
    const weeksDiff = scrolledMoment.diff(minMomentStartOfMonth, 'weeks');

    if (Math.abs(weeksDiff) >= 3) {
        const previousWeekForScrolledMoment = moment(
            scrolledMoment.toDate(),
        ).add(-1, 'week');

        if (previousWeekForScrolledMoment.isSame(scrolledMoment, 'month')) {
            return previousWeekForScrolledMoment;
        }

        return getEndDateOfMonth(previousWeekForScrolledMoment);
    }
}

/**
 * Получает последний день месяца, но часы/минуты/... оставляет как в исходном Moment
 */
function getEndDateOfMonth(m: Moment): Moment {
    return moment(m.toDate())
        .endOf('month')
        .hours(m.hours())
        .minutes(m.minutes())
        .seconds(m.seconds())
        .milliseconds(m.milliseconds());
}
