import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';

import Card from './Card';

export default {
    title: 'Example/Card',
    component: Card,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Card x="8" y="5" shadow="default">
        <Box below="2">
            <div style={{height: '100px', background: '#e6e6e6'}} />
        </Box>
    </Card>
);

export const Grey: TStorybookFunctionComponent = () => (
    <Card x="8" y="5" background="grey">
        <Box below="2">
            <div style={{height: '100px', background: '#fff'}} />
        </Box>
    </Card>
);

export const Shadow: TStorybookFunctionComponent = () => (
    <Box between="4" style={{background: '#f8f8f8'}} inset="2">
        <Card inset="2" below="4">
            No Shadow
        </Card>
        <Card inset="2" below="4" shadow="default">
            Shadow default
        </Card>
        <Card inset="2" below="4" shadow="popup">
            Shadow popup
        </Card>
    </Box>
);

export const Radius: TStorybookFunctionComponent = () => (
    <Box between="4" style={{background: '#000000'}} inset="2">
        <Card inset="2" below="4" radius="s">
            Radius s
        </Card>
        <Card inset="2" below="4" radius="m">
            Radius m default
        </Card>
        <Card inset="2" below="4" radius="l">
            Radius l
        </Card>
    </Box>
);

export const Border: TStorybookFunctionComponent = () => (
    <Box between="4" inset="2">
        <Card inset="2" below="4" radius="l" border="thin">
            Thin border
        </Card>
        <Card inset="2" below="4" radius="l" border="thin" withHover>
            Thin border with hover
        </Card>
        <Card inset="2" below="4" radius="l" border="normal">
            Normal border
        </Card>
        <Card inset="2" below="4" radius="l" border="normal" withHover>
            Normal border with hover
        </Card>
        <Card inset="2" below="4" radius="l">
            No border
        </Card>
    </Box>
);
