import React from 'react';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Box, {IBoxProps} from '../Box/Box';

import cx from './Card.scss';

export type TCardShadow = 'default' | 'popup' | 'none';
export type TCardRadius = 'xs' | 's' | 'm' | 'l';
export type TCardBorder = 'thin' | 'normal';
export type TCardBackground = 'light' | 'grey';

export interface ICardProps extends IBoxProps, IWithQaAttributes {
    shadow?: TCardShadow;
    radius?: TCardRadius;
    border?: TCardBorder;
    background?: TCardBackground;

    /**
     * Желтая рамка при наведении
     */
    withHover?: boolean;
}

const Card: React.FC<ICardProps> = React.forwardRef<HTMLElement, ICardProps>(
    (
        {
            shadow,
            withHover,
            background = 'light',
            radius = 'l',
            border,
            className,
            ...props
        },
        ref,
    ) => (
        <Box
            className={cx(
                {card_withHover: withHover},
                background && `card_background_${background}`,
                shadow && `card_shadow_${shadow}`,
                radius && `card_radius_${radius}`,
                border && ['card_border', `card_border_${border}`],
                className,
            )}
            ref={ref}
            {...props}
        />
    ),
);

Card.displayName = 'Card';

export default Card;
