import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Carousel from './Carousel';

import cx from './__doc__/styles.scss';

export default {
    title: 'Example/Carousel',
    component: Carousel,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <div className={cx('container')}>
        <Carousel>
            <div className={cx('item')} style={{width: 140}}>
                0
            </div>
            <div className={cx('item')} style={{width: 300}}>
                1
            </div>
            <div className={cx('item')} style={{width: 400}}>
                2
            </div>
            <div className={cx('item')} style={{width: 100}}>
                3
            </div>
            <div className={cx('item')} style={{width: 600}}>
                4
            </div>
            <div className={cx('item')} style={{width: 300}}>
                5
            </div>
            <div className={cx('item')} style={{width: 400}}>
                6
            </div>
        </Carousel>
    </div>
);

export const NativeScroll: TStorybookFunctionComponent = () => (
    <div className={cx('container')}>
        <Carousel scroll="native">
            <div className={cx('item')} style={{width: 140}}>
                0
            </div>
            <div className={cx('item')} style={{width: 300}}>
                1
            </div>
            <div className={cx('item')} style={{width: 400}}>
                2
            </div>
            <div className={cx('item')} style={{width: 100}}>
                3
            </div>
            <div className={cx('item')} style={{width: 600}}>
                4
            </div>
            <div className={cx('item')} style={{width: 300}}>
                5
            </div>
            <div className={cx('item')} style={{width: 400}}>
                6
            </div>
        </Carousel>
    </div>
);

export const Spacing: TStorybookFunctionComponent = () => (
    <div className={cx('container')}>
        <Carousel
            spaceBetween={1}
            leftOffset={20}
            rightOffset={20}
            spaceBefore={10}
            spaceAfter={10}
        >
            <div className={cx('item-sm')}>0</div>
            <div className={cx('item-sm')}>1</div>
            <div className={cx('item-sm')}>2</div>
            <div className={cx('item-sm')}>3</div>
            <div className={cx('item-sm')}>4</div>
            <div className={cx('item-sm')}>5</div>
            <div className={cx('item-sm')}>6</div>
            <div className={cx('item-sm')}>7</div>
            <div className={cx('item-sm')}>8</div>
            <div className={cx('item-sm')}>9</div>
            <div className={cx('item-sm')}>10</div>
        </Carousel>
    </div>
);
Spacing.parameters = {
    info: {
        comment:
            'Для элементов можно задать размер межу ними (spaceBetween), отступ перед первым элементом (spaceBefore), отступ после последнего элемента (spaceAfter), отступ слева при скролле (leftOffset), отступ справа при скролле (rightOffset)',
    },
};

export const ScrollToInitial: TStorybookFunctionComponent = () => (
    <div className={cx('container', 'container-fixed')}>
        <Carousel
            className={cx('container-fixed')}
            spaceBetween={2}
            initialVisibleIndex={4}
        >
            <div className={cx('item-sm')}>0</div>
            <div className={cx('item-sm')}>1</div>
            <div className={cx('item-sm')}>2</div>
            <div className={cx('item-sm')}>3</div>
            <div className={cx('item-sm', 'item-selected')}>4</div>
            <div className={cx('item-sm')}>5</div>
            <div className={cx('item-sm')}>6</div>
            <div className={cx('item-sm')}>7</div>
            <div className={cx('item-sm')}>8</div>
            <div className={cx('item-sm')}>9</div>
            <div className={cx('item-sm')}>10</div>
        </Carousel>

        <Carousel
            className={cx('container-fixed')}
            spaceBetween={2}
            initialVisibleIndex={0}
        >
            <div className={cx('item-sm', 'item-selected')}>0</div>
            <div className={cx('item-sm')}>1</div>
            <div className={cx('item-sm')}>2</div>
            <div className={cx('item-sm')}>3</div>
            <div className={cx('item-sm')}>4</div>
            <div className={cx('item-sm')}>5</div>
            <div className={cx('item-sm')}>6</div>
            <div className={cx('item-sm')}>7</div>
            <div className={cx('item-sm')}>8</div>
            <div className={cx('item-sm')}>9</div>
            <div className={cx('item-sm')}>10</div>
        </Carousel>

        <Carousel
            className={cx('container-fixed')}
            spaceBetween={2}
            initialVisibleIndex={10}
        >
            <div className={cx('item-sm')}>0</div>
            <div className={cx('item-sm')}>1</div>
            <div className={cx('item-sm')}>2</div>
            <div className={cx('item-sm')}>3</div>
            <div className={cx('item-sm')}>4</div>
            <div className={cx('item-sm')}>5</div>
            <div className={cx('item-sm')}>6</div>
            <div className={cx('item-sm')}>7</div>
            <div className={cx('item-sm')}>8</div>
            <div className={cx('item-sm')}>9</div>
            <div className={cx('item-sm', 'item-selected')}>10</div>
        </Carousel>
    </div>
);
ScrollToInitial.parameters = {
    info: {
        comment: `
        Если карусель элементов интерактивная, то можно скроллить к активному элементу при отображении.
        !!NB!! Работает, только если карусель имеет фиксированную ширину.
        `,
    },
};

export const Gradient: TStorybookFunctionComponent = () => (
    <div className={cx('container')}>
        <Carousel gradient>
            <div className={cx('item-sm', 'bg_dark')}>1</div>
            <div className={cx('item-sm', 'bg_dark')}>2</div>
            <div className={cx('item-sm', 'bg_dark')}>0</div>
            <div className={cx('item-sm', 'bg_dark')}>3</div>
            <div className={cx('item-sm', 'bg_dark')}>4</div>
            <div className={cx('item-sm', 'bg_dark')}>5</div>
            <div className={cx('item-sm', 'bg_dark')}>6</div>
            <div className={cx('item-sm', 'bg_dark')}>7</div>
            <div className={cx('item-sm', 'bg_dark')}>8</div>
            <div className={cx('item-sm', 'bg_dark')}>9</div>
            <div className={cx('item-sm', 'bg_dark')}>10</div>
        </Carousel>
    </div>
);

export const Mini: TStorybookFunctionComponent = () => (
    <div className={cx('container')} style={{width: 202}}>
        <Carousel type="mini" arrowsType="dark">
            <div className={cx('item-sm')}>0</div>
            <div className={cx('item-sm')}>1</div>
            <div className={cx('item-sm')}>2</div>
            <div className={cx('item-sm')}>3</div>
            <div className={cx('item-sm')}>4</div>
            <div className={cx('item-sm')}>5</div>
            <div className={cx('item-sm')}>6</div>
            <div className={cx('item-sm')}>7</div>
            <div className={cx('item-sm')}>8</div>
            <div className={cx('item-sm')}>9</div>
            <div className={cx('item-sm')}>10</div>
        </Carousel>
    </div>
);

export const MiniBottomArrows: TStorybookFunctionComponent = () => (
    <div className={cx('container')} style={{width: 202}}>
        <Carousel type="mini" arrowsType="dark" arrowsPosition="bottom">
            <div className={cx('item-sm')}>0</div>
            <div className={cx('item-sm')}>1</div>
            <div className={cx('item-sm')}>2</div>
            <div className={cx('item-sm')}>3</div>
            <div className={cx('item-sm')}>4</div>
            <div className={cx('item-sm')}>5</div>
            <div className={cx('item-sm')}>6</div>
            <div className={cx('item-sm')}>7</div>
            <div className={cx('item-sm')}>8</div>
            <div className={cx('item-sm')}>9</div>
            <div className={cx('item-sm')}>10</div>
        </Carousel>
    </div>
);

export const DontNeedArrows: TStorybookFunctionComponent = () => (
    <div className={cx('container')}>
        <Carousel spaceBetween={1}>
            <div className={cx('item-sm')}>0</div>
            <div className={cx('item-sm')}>1</div>
            <div className={cx('item-sm')}>2</div>
        </Carousel>
    </div>
);
