import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import ArrowLeftIcon from 'icons/16/ArrowLeft';
import ArrowRightIcon from 'icons/16/ArrowRight';
import RoundButton, {
    IRoundButtonProps,
} from 'components/RoundButton/RoundButton';

import cx from './CarouselButton.scss';

export type TArrowsType = 'light' | 'dark';
export type TArrowsPositionType = 'center' | 'bottom';

type TRoundButtonTheme = {
    size: IRoundButtonProps['size'];
    theme: IRoundButtonProps['theme'];
};

const lightTheme: TRoundButtonTheme = {
    size: 'm',
    theme: 'white',
};

const darkTheme: TRoundButtonTheme = {
    size: 's',
    theme: 'dark',
};

export interface ICarouselButtonProps extends IWithClassName {
    type: 'next' | 'prev';
    arrowsType?: TArrowsType;
    arrowsPosition?: TArrowsPositionType;
    disabled?: boolean;
    onClick: () => void;
}

const CarouselButton: FunctionComponent<ICarouselButtonProps> = ({
    className,
    type,
    arrowsType,
    arrowsPosition,
    disabled,
    onClick,
}) => {
    const buttonTheme = arrowsType === 'light' ? lightTheme : darkTheme;

    return (
        <div
            className={cx(
                'root',
                `root_direction_${type}`,
                `root_type_${arrowsType}`,
                `root_position_${arrowsPosition}`,
                className,
            )}
        >
            <RoundButton
                icon={type === 'next' ? <ArrowRightIcon /> : <ArrowLeftIcon />}
                onClick={onClick}
                disabled={disabled}
                {...buttonTheme}
            />
        </div>
    );
};

CarouselButton.defaultProps = {
    arrowsPosition: 'center',
    arrowsType: 'light',
};

export default CarouselButton;
