/**
 * Возвращает отступ слева
 */
export function getPrevOffsetByRefs(
    listRef: HTMLDivElement | null,
    nextItemRef: HTMLDivElement | null,
    leftOffset: number = 0,
): number {
    if (!listRef || !nextItemRef) {
        return 0;
    }

    const listRect = listRef.getBoundingClientRect();
    const nextItemRect = nextItemRef.getBoundingClientRect();

    const offset = nextItemRect.left - listRect.left - leftOffset;

    return Math.max(offset, -leftOffset);
}

/**
 * Возвращает отступ слева
 */
export function getNextOffsetByRefs(
    listRef: HTMLDivElement | null,
    nextItemRef: HTMLDivElement | null,
    rightOffset: number = 0,
): number {
    if (!listRef || !nextItemRef) {
        return 0;
    }

    const listRect = listRef.getBoundingClientRect();
    const itemRect = nextItemRef.getBoundingClientRect();

    return itemRect.right - listRect.right + rightOffset;
}
