import {withBemMod} from '@bem-react/core';
import {cn} from '@bem-react/classname';

import {IButtonProps} from 'components/Button/Button';

import './withKindCheck.scss';

export const cnButton = cn('YTButton');

export interface IButtonKindCheckProps extends IButtonProps {
    kind?: 'check';
}

export const withKindCheck = withBemMod<IButtonKindCheckProps>(
    cnButton(),
    {
        kind: 'check',
    },
    ButtonComponent =>
        // eslint-disable-next-line react/display-name
        ({kind, ...props}) =>
            <ButtonComponent {...props} type="button" />,
);
