import React, {ReactNode} from 'react';

import {useMobile} from 'utilities/hooks/useMobile';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import CheckButton from 'components/CheckButton/CheckButton';

import cx from './CheckButtonWithAdditionalBlock.scss';

interface ICheckButtonWithAdditionalBlockProps extends IWithQaAttributes {
    checked: boolean;
    disabled: boolean;
    onChange: () => void;
    children?: ReactNode;
    additionalBlock?: ReactNode;
    isNewFilters?: boolean;
}

const CheckButtonWithAdditionalBlock: React.FC<ICheckButtonWithAdditionalBlockProps> =
    ({
        isNewFilters,
        children,
        additionalBlock,
        checked,
        disabled,
        onChange,
        ...rest
    }) => {
        const isMobile = useMobile();

        return (
            <CheckButton
                size={isMobile ? 'l' : 'm-inset'}
                checked={checked}
                disabled={disabled}
                onClick={onChange}
                width={isMobile ? 'max' : 'auto'}
                {...prepareQaAttributes(rest)}
            >
                <span className={cx('inner', isMobile && 'inner_mobile')}>
                    <span>{children}</span>
                    {Boolean(additionalBlock) && (
                        <span
                            className={cx(
                                'footnote',
                                !isNewFilters && isMobile && 'footnote_mobile',
                            )}
                        >
                            {additionalBlock}
                        </span>
                    )}
                </span>
            </CheckButton>
        );
    };

export default CheckButtonWithAdditionalBlock;
