import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';
import {EAuthorizationOrderType} from 'server/api/OrdersAPI/types/IOrderAuthorization';

import CheckOrderAuthorization from './CheckOrderAuthorization';

export default {
    title: 'Example/CheckOrderAuthorization',
    component: CheckOrderAuthorization,
} as Meta;

const UNAUTHORIZED_USER_INFO = {
    authorizePath: 'string',
    avatarPath: '',
    passportPath: 'string',
    yu: 'string',
};

export const Loading: TStorybookFunctionComponent = () => {
    return (
        <CheckOrderAuthorization
            userInfo={UNAUTHORIZED_USER_INFO}
            checkOrderAuthorization={noop as any}
            orderAuthorization={{
                checkAuthorization: {
                    isError: false,
                    isLoading: true,
                    isSuccess: false,
                    orderIds: {
                        id: 'ID',
                        yandexOrderId: 'YANDEX ORDER ID',
                        orderType: EAuthorizationOrderType.HOTEL_EXPEDIA,
                    },
                },
                createAuthorization: {
                    isError: false,
                    isLoading: false,
                    isSuccess: false,
                },
            }}
        />
    );
};

export const Simple: TStorybookFunctionComponent = () => {
    return (
        <CheckOrderAuthorization
            userInfo={UNAUTHORIZED_USER_INFO}
            checkOrderAuthorization={noop as any}
            orderAuthorization={{
                checkAuthorization: {
                    isError: true,
                    isLoading: false,
                    isSuccess: false,
                    orderIds: {
                        id: 'ID',
                        yandexOrderId: 'YANDEX ORDER ID',
                        orderType: EAuthorizationOrderType.HOTEL_EXPEDIA,
                    },
                },
                createAuthorization: {
                    isError: false,
                    isLoading: false,
                    isSuccess: false,
                },
            }}
        />
    );
};
