import {connect} from 'react-redux';

import {
    checkOrderAuthorizationActions,
    createOrderAuthorizationActions,
    TStartCheckOrderActionType,
    TStartCreateOrderActionType,
} from 'reducers/common/checkOrderAuthorization/actions';
import {StoreInterface} from 'reducers/storeTypes';

import checkOrderAuthorizationSelector from 'selectors/common/checkOrderAuthorizationSelector';

import CheckOrderAuthorization from './CheckOrderAuthorization';

const mapStateToProps = checkOrderAuthorizationSelector;

const mapDispatchToProps = {
    checkOrderAuthorization: checkOrderAuthorizationActions.request,
    createOrderAuthorization: createOrderAuthorizationActions.request,
};

type TCheckOrderAuthorizationPropsContainer = ReturnType<
    typeof checkOrderAuthorizationSelector
>;
interface ICheckOrderAuthorizationDispatchContainer {
    checkOrderAuthorization: TStartCheckOrderActionType;
    createOrderAuthorization: TStartCreateOrderActionType;
}

export type TCheckOrderAuthorizationContainer =
    TCheckOrderAuthorizationPropsContainer &
        ICheckOrderAuthorizationDispatchContainer;

/* Container */
const CheckOrderAuthorizationContainer = connect<
    TCheckOrderAuthorizationPropsContainer,
    ICheckOrderAuthorizationDispatchContainer,
    {},
    StoreInterface
>(
    mapStateToProps,
    mapDispatchToProps,
)(CheckOrderAuthorization);

export default CheckOrderAuthorizationContainer;
