import {compose, composeU} from '@bem-react/core';

import {
    Checkbox as LegoDesktopCheckbox,
    ICheckboxProps as ILegoCheckboxProps,
    withViewOutline,
    withLinesOne,
    withSizeS,
    withSizeM,
} from '@yandex-lego/components/Checkbox/desktop';

/** _theme */
import {withThemePrimary} from '../_theme/Checkbox_theme_primary';
import {cnCheckbox} from '../cnCheckbox';

const YTLegoCheckboxWrapper = (props: ILegoCheckboxProps) => (
    <LegoDesktopCheckbox
        {...props}
        className={cnCheckbox(null, [props.className])}
    />
);

export const CheckboxPresenter = compose(
    composeU(withSizeS, withSizeM),
    composeU(withThemePrimary),
    withLinesOne,
    withViewOutline,
)(YTLegoCheckboxWrapper);
