import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import Button from 'components/Button/Button';

import CornerCounter from './CornerCounter';

export default {
    title: 'Example/CornerCounter',
    component: CornerCounter,
} as Meta;

export const Position: TStorybookFunctionComponent = () => (
    <Box between="4">
        <Box inline between="4">
            <CornerCounter count="2" direction="top-left">
                <Button>top-left</Button>
            </CornerCounter>

            <CornerCounter count="1">
                <Button>top-right</Button>
            </CornerCounter>

            <CornerCounter count="3" direction="bottom-left">
                <Button>bottom-left</Button>
            </CornerCounter>

            <CornerCounter count="4" direction="bottom-right">
                <Button>bottom-right</Button>
            </CornerCounter>
        </Box>

        <CornerCounter count="1">
            <CornerCounter count="2" direction="top-left">
                <CornerCounter count="3" direction="bottom-left">
                    <CornerCounter count="4" direction="bottom-right">
                        <Button>all-corners</Button>
                    </CornerCounter>
                </CornerCounter>
            </CornerCounter>
        </CornerCounter>
    </Box>
);
Position.parameters = {
    info: {
        title: 'Расположение',
    },
};

export const RenderZero: TStorybookFunctionComponent = () => (
    <Box inline between="4">
        <CornerCounter count="0">
            <Button>renderZero = false</Button>
        </CornerCounter>

        <CornerCounter count="0" renderZero>
            <Button>renderZero = true</Button>
        </CornerCounter>
    </Box>
);
RenderZero.parameters = {
    info: {
        title: 'Отображение нулевого значения',
    },
};

export const Overflow: TStorybookFunctionComponent = () => (
    <Box inline between="4">
        <CornerCounter count={11}>
            <Button>2 знака</Button>
        </CornerCounter>

        <CornerCounter count={11111}>
            <Button>5 знаков</Button>
        </CornerCounter>
    </Box>
);
Overflow.parameters = {
    info: {
        title: 'Переполнение',
    },
};
