import React from 'react';

import {BLOCK_RESTRICTIONS_ICONS} from 'components/CountryRestrictions/components/CountryRestrictionsDetailed/constants';

import {IRichString} from 'server/api/AviaCountryRestrictionsApi/types/IRichString';
import {IGetExtendedCountryRestrictionsMetric} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiResponse';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/covidBanner';

import Text, {ITextProps} from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

import RichString from './RichString';

import cx from './CountryRestrictionsDetailed.scss';

function renderList(
    list: IRichString[] | undefined,
    title: string,
    isMobile: boolean,
): React.ReactNode {
    if (list === undefined || list.length === 0) {
        return null;
    }

    const lastIndex = list.length - 1;

    return (
        <div>
            <Text size={isMobile ? 's' : 'm'} weight="bold">
                {`${title}:`}
            </Text>
            {list.map((richStr, index) => (
                <li className={cx('listElement')} key={index}>
                    <RichString
                        text={richStr}
                        endOfString={index === lastIndex ? '.' : ';'}
                        deleteSymbolsFromEndOfString=".;"
                    />
                </li>
            ))}
        </div>
    );
}

export interface IBlockRestrictionsProps {
    metric: IGetExtendedCountryRestrictionsMetric;
}

const BlockRestriction: React.FC<IBlockRestrictionsProps> = ({metric}) => {
    const {isMobile} = useDeviceType();
    const {title, icon24, metricValue} = metric;

    const titleTextProps: ITextProps = {
        size: isMobile ? 'm' : 'l',
        weight: 'bold',
        tag: 'div',
    };

    const IconNode =
        BLOCK_RESTRICTIONS_ICONS[isMobile ? 'mobile' : 'desktop'][icon24];

    return (
        <Flex inline between={3} alignItems="flex-start" flexWrap="nowrap">
            {IconNode && <IconNode className={cx('icon')} />}

            <Flex
                className={cx('rightColumn')}
                flexDirection="column"
                between={isMobile ? 2 : 4}
                textSize={isMobile ? 's' : 'm'}
            >
                <RichString text={title} textProps={titleTextProps} />

                {metricValue?.text && (
                    <div>
                        <RichString
                            text={metricValue?.text}
                            endOfString="."
                            deleteSymbolsFromEndOfString=".;"
                        />
                    </div>
                )}

                {renderList(
                    metricValue?.additions,
                    i18nBlock.additions(),
                    isMobile,
                )}
                {renderList(
                    metricValue?.exclusions,
                    i18nBlock.exclusions(),
                    isMobile,
                )}
            </Flex>
        </Flex>
    );
};

export default React.memo(BlockRestriction);
