import React from 'react';

import {
    EExtendedCountryRestrictionsMetricIcons,
    EPointType,
    IGetExtendedCountryRestrictionsMetric,
    IGetExtendedCountryRestrictionsResponse,
} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiResponse';
import {ERichStringBlockType} from 'server/api/AviaCountryRestrictionsApi/types/IRichString';
import {TStationKey} from 'types/PointKey';

import * as i18nBlock from 'i18n/covidBanner';

import Flex from 'components/Flex/Flex';
import BlockRestriction from 'components/CountryRestrictions/components/CountryRestrictionsDetailed/BlockRestriction';

export interface IDescriptionRestriction {
    countryRestrictions: IGetExtendedCountryRestrictionsResponse;
}

const restrictionMessageDetailed: IGetExtendedCountryRestrictionsMetric = {
    title: {
        data: [
            {
                blockType: ERichStringBlockType.TEXT,
                data: {text: i18nBlock.flightConditionsCouldHaveBeenChanged()},
            },
        ],
    },
    icon24: EExtendedCountryRestrictionsMetricIcons.WARNING_FILLED,
    metricName: 'restrictionMessageDetailed',
    metricValue: {
        additions: [],
        exclusions: [],
        lastModificationTime: 'never',
        point_info: {
            geo_id: null,
            point_key: '' as TStationKey,
            type: EPointType.UNKNOWN,
            title: {},
        },
        text: {
            data: [
                {
                    blockType: ERichStringBlockType.TEXT,
                    data: {text: i18nBlock.moreAboutChanges1()},
                },
                {
                    blockType: ERichStringBlockType.URL,
                    data: {
                        text: i18nBlock.moreAboutChanges2(),
                        url: i18nBlock.moreAboutChangesUrl(),
                    },
                },
            ],
        },
        updatedTime: 'never',
    },
};

const DescriptionRestriction: React.FC<IDescriptionRestriction> = ({
    countryRestrictions,
}) => {
    const {expandedBannerMetrics} = countryRestrictions;

    return (
        <Flex above={6} between={5} flexDirection="column">
            {expandedBannerMetrics.map(metric => (
                <BlockRestriction key={metric.metricName} metric={metric} />
            ))}

            <BlockRestriction metric={restrictionMessageDetailed} />
        </Flex>
    );
};

export default React.memo(DescriptionRestriction);
