import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';
import {EExtendedCountryRestrictionsMetricIcons} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiResponse';

import PlaneMobile from 'icons/24/Plane';
import PlaneDesktop from 'icons/36/Plane';
import ShildMobile from 'icons/24/Shild';
import ShildDesktop from 'icons/36/Shild';
import CardMobile from 'icons/24/Card';
import CardDesktop from 'icons/36/Card';
import QuestionnaireMobile from 'icons/24/Questionnaire';
import QuestionnaireDesktop from 'icons/36/Questionnaire';
import QuarantineMobile from 'icons/24/Quarantine';
import QuarantineDesktop from 'icons/36/Quarantine';
import DiscoveryMobile from 'icons/24/Discovery';
import DiscoveryDesktop from 'icons/36/Discovery';
import WarningFilledMobile from 'icons/24/WarningFilled';
import WarningFilledDesktop from 'icons/36/WarningFilled';
import CovidShildMobile from 'icons/24/CovidShild';
import CovidShildDesktop from 'icons/36/CovidShild';
import GlobeMobile from 'icons/24/Globe';
import GlobeDesktop from 'icons/36/Globe';

type TBlockRestrictionIconsField = {
    [key in EExtendedCountryRestrictionsMetricIcons]: (
        props: IIconProps,
    ) => ReactElement;
};

export interface IBlockRestrictionIcons {
    mobile: TBlockRestrictionIconsField;
    desktop: TBlockRestrictionIconsField;
}

export const BLOCK_RESTRICTIONS_ICONS: IBlockRestrictionIcons = {
    mobile: {
        Plane: PlaneMobile,
        Shild: ShildMobile,
        Card: CardMobile,
        Questionnaire: QuestionnaireMobile,
        Quarantine: QuarantineMobile,
        Discovery: DiscoveryMobile,
        WarningFilled: WarningFilledMobile,
        CovidShild: CovidShildMobile,
        Globe: GlobeMobile,
    },
    desktop: {
        Plane: PlaneDesktop,
        Shild: ShildDesktop,
        Card: CardDesktop,
        Questionnaire: QuestionnaireDesktop,
        Quarantine: QuarantineDesktop,
        Discovery: DiscoveryDesktop,
        WarningFilled: WarningFilledDesktop,
        CovidShild: CovidShildDesktop,
        Globe: GlobeDesktop,
    },
};
