import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Card from 'components/Card/Card';
import Skeleton from 'components/Skeletons/Skeleton/Skeleton';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import Flex from 'components/Flex/Flex';

import cx from './CountryRestrictionsSkeleton.scss';

interface ICountryRestrictionsSkeletonProps extends IWithClassName {}

const CountryRestrictionsSkeleton: React.FC<ICountryRestrictionsSkeletonProps> =
    ({className}) => {
        const deviceType = useDeviceType();
        const {isMobile} = deviceType;

        return (
            <Card
                className={cx(deviceMods('root', deviceType), className)}
                shadow="default"
                x={isMobile ? 4 : 8}
                y={4}
            >
                <Flex inline alignItems="center" between={4}>
                    <Skeleton className={cx('icon')} withAnimation />
                    <div className={cx('text')}>
                        <TextSkeleton
                            size={isMobile ? 'm' : 'l'}
                            className={cx('country')}
                            withAnimation
                        />
                        <Flex inline flexWrap="wrap">
                            <TextSkeleton
                                className={cx('quarantine')}
                                size="s"
                                withAnimation
                            />
                            <TextSkeleton
                                className={cx('test')}
                                size="s"
                                withAnimation
                            />
                            {!isMobile && (
                                <TextSkeleton
                                    className={cx('visa')}
                                    size="s"
                                    withAnimation
                                />
                            )}
                        </Flex>
                    </div>
                </Flex>
            </Card>
        );
    };

export default CountryRestrictionsSkeleton;
