import {useEffect, useState} from 'react';

import ICountryRestrictionsInfo from 'components/CountryRestrictions/types/ICountryRestrictionsInfo';
import {TGetCountryRestrictionsRequest} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiRequest';
import EAsyncStatus from 'types/common/EAsyncStatus';

import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

export default function useFetchCountryRestrictions(
    requestParams: TGetCountryRestrictionsRequest,
): ICountryRestrictionsInfo {
    const [countryRestrictions, setCountryRestrictions] =
        useState<ICountryRestrictionsInfo>({
            status: null,
            data: null,
        });

    useEffect(() => {
        (async (): Promise<void> => {
            setCountryRestrictions({
                status: EAsyncStatus.LOADING,
                data: null,
            });

            try {
                const countryRestrictionsResponse =
                    await aviaBrowserProvider.getExtendedCountryRestrictions(
                        requestParams,
                    );

                setCountryRestrictions({
                    status: EAsyncStatus.SUCCESS,
                    data: countryRestrictionsResponse,
                });
            } catch {
                setCountryRestrictions({
                    status: EAsyncStatus.ERROR,
                    data: null,
                });
            }
        })();
    }, [requestParams]);

    return countryRestrictions;
}
