import {ComponentType} from 'react';

import {IIconProps} from 'icons/types/icon';
import {ECountryRestrictionsColor} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiResponse';

import {IDevice} from 'reducers/common/commonReducerTypes';

import CheckCircleIconMobile from 'icons/16/CheckCircle';
import CheckCircleIconDesktop from 'icons/24/CheckCircle';
import StopIconMobile from 'icons/16/Stop';
import WarningFilledIconMobile from 'icons/16/WarningFilled';
import WarningFilledIconDesktop from 'icons/24/WarningFilled';
import StopIconDesktop from 'icons/24/Stop';

export function getBannerPreviewIcon(
    color: ECountryRestrictionsColor,
    {isMobile}: IDevice,
): ComponentType<IIconProps> {
    switch (color) {
        case ECountryRestrictionsColor.GREEN:
            return isMobile ? CheckCircleIconMobile : CheckCircleIconDesktop;
        case ECountryRestrictionsColor.GRAY:
            return isMobile
                ? WarningFilledIconMobile
                : WarningFilledIconDesktop;
        case ECountryRestrictionsColor.RED:
            return isMobile ? StopIconMobile : StopIconDesktop;
    }
}
