import {EHotelBadgeType} from 'types/hotels/offer/IHotelOffer';
import {
    EHotelGeoFeatureIcon,
    MainAmenityIdType,
} from 'types/hotels/hotel/IHotel';
import {ERefundType} from 'types/hotels/offer/IHotelOfferCancellationInfo';
import {IHotelsCrossSale} from 'server/api/HotelsCrossSaleApi/types/IHotelsCrossSale';

import {CurrencyType} from 'utilities/currency/CurrencyType';

export const HOTELS_CROSS_SALE_DATA: IHotelsCrossSale = {
    region: {
        geoId: 239,
        linguistics: {
            nominativeCase: 'Сочи',
            genitiveCase: 'Сочи',
            dativeCase: 'Сочи',
            prepositionalCase: 'Сочи',
            preposition: 'в',
            locativeCase: '',
            directionalCase: '',
            ablativeCase: '',
            accusativeCase: 'Сочи',
            instrumentalCase: 'Сочи',
        },
        slug: 'sochi',
    },
    minPriceInRegion: {
        value: 350,
        currency: CurrencyType.RUB,
    },
    bboxAsString: '39.525700,43.360357~39.980168,43.765333',
    bboxAsStruct: [
        {
            lon: 39.5257,
            lat: 43.360357,
        },
        {
            lon: 39.980168,
            lat: 43.765333000000005,
        },
    ],
    hotels: [
        {
            hotel: {
                permalink: '1245187812',
                hotelSlug: 'sochi/akvamarin-ialtinskaia-ulitsa',
                name: 'Аквамарин',
                category: {
                    id: 'hotels',
                    name: 'Гостиница',
                },
                coordinates: {
                    lon: 39.869694,
                    lat: 43.508095,
                },
                address:
                    'Россия, Краснодарский край, Сочи, жилой район Хоста, Ялтинская улица, 4А',
                stars: 2,
                rating: 4.4,
                totalTextReviewCount: 385,
                totalImageCount: 195,
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/910613/2a000001620f9c9bffc205e54ae5888c73b3/%s',
                        id: 'urn:yandex:sprav:photo:74656951',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 333,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 533,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 683,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 853,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 1000,
                                width: 1500,
                            },
                        ],
                        tags: ['Enter'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/223006/2a0000015b399d6a3ae8ae3c9b02dbc3117c/%s',
                        id: 'urn:yandex:sprav:photo:2324305',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 38,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 56,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 75,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 113,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 225,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 375,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 600,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 768,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 768,
                                width: 1024,
                            },
                            {
                                size: 'orig',
                                height: 768,
                                width: 1024,
                            },
                        ],
                        tags: ['Exterior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/481843/2a000001620f9a886a8129b65d33b0945edb/%s',
                        id: 'urn:yandex:sprav:photo:74657747',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 333,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 533,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 683,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 853,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 1000,
                                width: 1500,
                            },
                        ],
                        tags: ['Exterior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/758957/2a000001607170e1da6d4193b3af0d60f755/%s',
                        id: 'urn:yandex:sprav:photo:14573627',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 38,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 56,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 75,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 112,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 225,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 375,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 600,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 768,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 960,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 3120,
                                width: 4160,
                            },
                        ],
                        tags: ['Exterior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/223006/2a0000015b399d7125acc250c112b79bcfa4/%s',
                        id: 'urn:yandex:sprav:photo:2324380',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 38,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 56,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 75,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 113,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 225,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 375,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 600,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 768,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 768,
                                width: 1024,
                            },
                            {
                                size: 'orig',
                                height: 768,
                                width: 1024,
                            },
                        ],
                        tags: ['Exterior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1018126/2a000001620f99d80bdac6d926c4594b7b5a/%s',
                        id: 'urn:yandex:sprav:photo:74657258',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 333,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 533,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 683,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 853,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 1000,
                                width: 1500,
                            },
                        ],
                        tags: ['Interior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/920214/2a000001620f98f95f5f31490d50471f627e/%s',
                        id: 'urn:yandex:sprav:photo:74656938',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 333,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 533,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 683,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 853,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 1000,
                                width: 1500,
                            },
                        ],
                        tags: ['Interior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1032555/2a000001620f99ace8276ca1be9b0d8a48a8/%s',
                        id: 'urn:yandex:sprav:photo:74657257',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 50,
                                width: 33,
                            },
                            {
                                size: 'XXS',
                                height: 75,
                                width: 50,
                            },
                            {
                                size: 'XS',
                                height: 100,
                                width: 67,
                            },
                            {
                                size: 'S',
                                height: 150,
                                width: 100,
                            },
                            {
                                size: 'M',
                                height: 300,
                                width: 200,
                            },
                            {
                                size: 'L',
                                height: 500,
                                width: 333,
                            },
                            {
                                size: 'XL',
                                height: 800,
                                width: 533,
                            },
                            {
                                size: 'XXL',
                                height: 1024,
                                width: 683,
                            },
                            {
                                size: 'XXXL',
                                height: 1280,
                                width: 853,
                            },
                            {
                                size: 'orig',
                                height: 1500,
                                width: 1000,
                            },
                        ],
                        tags: ['Interior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/758957/2a000001620f99713b3dcd6740923295ceea/%s',
                        id: 'urn:yandex:sprav:photo:74657738',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 333,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 533,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 683,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 853,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 1000,
                                width: 1500,
                            },
                        ],
                        tags: ['Interior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/226077/2a000001620f98e55f3583b3547adfba9f64/%s',
                        id: 'urn:yandex:sprav:photo:74657736',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 333,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 533,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 683,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 853,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 1000,
                                width: 1500,
                            },
                        ],
                        tags: ['Interior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/2355061/2a0000017609b27a2cd9b2ceecee74e7d9cf/%s',
                        id: 'urn:yandex:sprav:photo:2355061_2a0000017609b27a2cd9b2ceecee74e7d9cf',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 29,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 44,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 59,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 88,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 176,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 293,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 469,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 600,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 750,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 1172,
                                width: 2000,
                            },
                        ],
                        tags: ['Panorama'],
                    },
                ],
                mainAmenities: [
                    {
                        id: MainAmenityIdType.WI_FI,
                        name: 'Wi-Fi',
                    },
                    {
                        id: MainAmenityIdType.AIR_CONDITIONING,
                        name: 'Кондиционер в номере',
                    },
                    {
                        id: MainAmenityIdType.PAYMENT_BY_CARD,
                        name: 'Оплата картой',
                    },
                ],
                amenityGroups: [],
                isFavorite: false,
                geoFeature: {
                    id: 'sea_distance',
                    icon: EHotelGeoFeatureIcon.SEA,
                    name: '150 м до моря',
                },
            },
            searchIsFinished: true,
            offers: [
                {
                    id: '4409eea0-d967-43ac-8fb5-9bb18edebe22',
                    name: '',
                    price: {
                        value: 750,
                        currency: CurrencyType.RUB,
                    },
                    operatorId: '44',
                    landingUrl: '',
                    cancellationInfo: {
                        hasFreeCancellation: false,
                        refundType: ERefundType.NON_REFUNDABLE,
                        refundRules: [
                            {
                                type: ERefundType.NON_REFUNDABLE,
                                startsAt: '',
                                endsAt: '',
                            },
                        ],
                    },
                    mealType: {
                        id: 'RO',
                        name: 'Без питания',
                    },
                    yandexOffer: true,
                    badges: [
                        {
                            id: EHotelBadgeType.TAXI_PROMOCODE,
                            text: 'Промокод на такси',
                        },
                    ],
                    offerYandexPlusInfo: {
                        points: 248,
                        eligible: true,
                    },
                },
            ],
            badges: [
                {
                    id: EHotelBadgeType.TAXI_PROMOCODE,
                    text: 'Промокод на такси',
                },
            ],
            searchedByUser: false,
        },
        {
            hotel: {
                permalink: '1350517402',
                hotelSlug: 'sochi/garden-hills',
                name: 'Garden Hills',
                category: {
                    id: 'hotels',
                    name: 'Гостиница',
                },
                coordinates: {
                    lon: 39.756597,
                    lat: 43.568673,
                },
                address:
                    'Россия, Краснодарский край, Сочи, микрорайон Бытха, улица Бытха, 3/1',
                stars: 2,
                rating: 4.3,
                totalTextReviewCount: 401,
                totalImageCount: 175,
                images: [
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/906486/2a000001653c30f8e99e2ec2cc01c168b324/%s',
                        id: 'urn:yandex:sprav:photo:105859464',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 35,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 52,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 70,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 105,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 209,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 349,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 558,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 714,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 893,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 2092,
                                width: 3000,
                            },
                        ],
                        tags: ['Enter'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1908863/2a0000016beaf5764610322f6b92edcd0e4e/%s',
                        id: 'urn:yandex:sprav:photo:199634773',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 38,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 56,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 75,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 113,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 225,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 375,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 600,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 768,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 960,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 1000,
                                width: 1333,
                            },
                        ],
                        tags: ['Exterior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1871013/2a0000016ac0f98f1214514ede32331e8e22/%s',
                        id: 'urn:yandex:sprav:photo:4MrUwXzmR7P3mJd8VLV5WseHWfoZdFB',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 28,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 42,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 56,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 84,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 168,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 281,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 449,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 575,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 719,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 2242,
                                width: 3992,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1886119/2a0000016beaf57ce14810185cc5fcd7814a/%s',
                        id: 'urn:yandex:sprav:photo:199634774',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 50,
                                width: 38,
                            },
                            {
                                size: 'XXS',
                                height: 75,
                                width: 56,
                            },
                            {
                                size: 'XS',
                                height: 100,
                                width: 75,
                            },
                            {
                                size: 'S',
                                height: 150,
                                width: 113,
                            },
                            {
                                size: 'M',
                                height: 300,
                                width: 225,
                            },
                            {
                                size: 'L',
                                height: 500,
                                width: 375,
                            },
                            {
                                size: 'XL',
                                height: 800,
                                width: 600,
                            },
                            {
                                size: 'XXL',
                                height: 1024,
                                width: 768,
                            },
                            {
                                size: 'XXXL',
                                height: 1280,
                                width: 960,
                            },
                            {
                                size: 'orig',
                                height: 1333,
                                width: 1000,
                            },
                        ],
                        tags: ['Exterior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1363250/2a000001653c315dbb72f0b917baa65573e4/%s',
                        id: 'urn:yandex:sprav:photo:105859467',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 333,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 533,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 682,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 852,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 1997,
                                width: 3000,
                            },
                        ],
                        tags: ['Interior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1881820/2a0000016ac0f8b75e5ca411cadaf4832f47/%s',
                        id: 'urn:yandex:sprav:photo:8vhUcGoEHP0eRAYgq6l9zWJ39igvxdWyA',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 333,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 533,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 683,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 853,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 3840,
                                width: 5760,
                            },
                        ],
                        tags: [],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1371862/2a0000016446aa287e14daec10c18723656d/%s',
                        id: 'urn:yandex:sprav:photo:98730036',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 33,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 50,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 67,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 100,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 200,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 333,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 533,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 683,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 853,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 3840,
                                width: 5760,
                            },
                        ],
                        tags: ['Exterior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1348156/2a0000016446a9d5f27587643ad6ea239e2a/%s',
                        id: 'urn:yandex:sprav:photo:98730034',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 28,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 42,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 56,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 84,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 169,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 281,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 450,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 576,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 720,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 3240,
                                width: 5760,
                            },
                        ],
                        tags: ['Exterior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1363250/2a0000016446a42d31f4e47190c03fe89d68/%s',
                        id: 'urn:yandex:sprav:photo:98730018',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 28,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 42,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 56,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 84,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 169,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 281,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 450,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 576,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 720,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 3232,
                                width: 5745,
                            },
                        ],
                        tags: ['Interior'],
                    },
                    {
                        urlTemplate:
                            'https://avatars.mds.yandex.net/get-altay/1363250/2a0000016446a331ed2836cf212b1321bd43/%s',
                        id: 'urn:yandex:sprav:photo:98730010',
                        sizes: [
                            {
                                size: 'XXXS',
                                height: 28,
                                width: 50,
                            },
                            {
                                size: 'XXS',
                                height: 42,
                                width: 75,
                            },
                            {
                                size: 'XS',
                                height: 56,
                                width: 100,
                            },
                            {
                                size: 'S',
                                height: 84,
                                width: 150,
                            },
                            {
                                size: 'M',
                                height: 169,
                                width: 300,
                            },
                            {
                                size: 'L',
                                height: 281,
                                width: 500,
                            },
                            {
                                size: 'XL',
                                height: 450,
                                width: 800,
                            },
                            {
                                size: 'XXL',
                                height: 576,
                                width: 1024,
                            },
                            {
                                size: 'XXXL',
                                height: 720,
                                width: 1280,
                            },
                            {
                                size: 'orig',
                                height: 3240,
                                width: 5760,
                            },
                        ],
                        tags: ['Interior'],
                    },
                ],
                mainAmenities: [
                    {
                        id: MainAmenityIdType.WI_FI,
                        name: 'Wi-Fi',
                    },
                    {
                        id: MainAmenityIdType.POOL,
                        name: 'Бассейн',
                    },
                    {
                        id: MainAmenityIdType.CAR_PARK,
                        name: 'Парковка',
                    },
                    {
                        id: MainAmenityIdType.AIR_CONDITIONING,
                        name: 'Кондиционер в номере',
                    },
                    {
                        id: MainAmenityIdType.PAYMENT_BY_CARD,
                        name: 'Оплата картой',
                    },
                    {
                        id: MainAmenityIdType.BEACH_LINE,
                        name: 'Пляжная линия: 2-я линия',
                    },
                ],
                amenityGroups: [],
                isFavorite: false,
                geoFeature: {
                    id: 'sea_distance',
                    icon: EHotelGeoFeatureIcon.SEA,
                    name: '850 м до моря',
                },
            },
            searchIsFinished: true,
            offers: [
                {
                    id: '14b5e171-1341-402c-8495-9755860b335e',
                    name: '',
                    price: {
                        value: 1000,
                        currency: CurrencyType.RUB,
                    },
                    operatorId: '44',
                    landingUrl: '',
                    cancellationInfo: {
                        hasFreeCancellation: true,
                        refundType: ERefundType.FULLY_REFUNDABLE,
                        refundRules: [
                            {
                                type: ERefundType.FULLY_REFUNDABLE,
                                startsAt: '2021-12-07T11:00:00Z',
                                endsAt: '2021-12-07T11:00:00Z',
                            },
                            {
                                type: ERefundType.NON_REFUNDABLE,
                                startsAt: '2021-12-07T11:00:00Z',
                                endsAt: '2021-12-07T11:00:00Z',
                            },
                        ],
                    },
                    mealType: {
                        id: 'RO',
                        name: 'Без питания',
                    },
                    yandexOffer: true,
                    badges: [
                        {
                            id: EHotelBadgeType.TAXI_PROMOCODE,
                            text: 'Промокод на такси',
                        },
                    ],
                    offerYandexPlusInfo: {
                        points: 330,
                        eligible: true,
                    },
                },
            ],
            badges: [
                {
                    id: EHotelBadgeType.TAXI_PROMOCODE,
                    text: 'Промокод на такси',
                },
            ],
            searchedByUser: false,
        },
    ],
    totalHotelCount: 2,
    regionImageUrl:
        'https://avatars.mds.yandex.net/get-travel-hotels/2409838/region_image_239_1/region-desktop',
};
