import {FunctionComponent} from 'react';
import createAutoCorrectedDatePipe from 'text-mask-addons/dist/createAutoCorrectedDatePipe';

import {
    MaskedInput,
    IMaskedInputProps,
} from 'components/MaskedInput/MaskedInput';

const DATE_PIPE = createAutoCorrectedDatePipe('dd.mm.yyyy');
const DATE_MASK = [/\d/, /\d/, '.', /\d/, /\d/, '.', /\d/, /\d/, /\d/, /\d/];

const DATE_PLACEHOLDER = '__.__.____';

const DateInput: FunctionComponent<IMaskedInputProps> = ({
    placeholder = DATE_PLACEHOLDER,
    ...props
}) => {
    return (
        <MaskedInput
            {...props}
            placeholder={placeholder}
            pipe={DATE_PIPE}
            mask={DATE_MASK}
            inputMode="numeric"
            type="tel"
        />
    );
};

export default DateInput;
