import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {use100vh} from 'hooks/use100vh';

export interface IDrawerContainerProps extends IWithClassName {}

const TOP_MARGIN = 48;

const DrawerContainer: React.FC<IDrawerContainerProps> = ({
    className,
    children,
}) => {
    const windowHeight = use100vh();
    const blockHeight = windowHeight ? windowHeight - TOP_MARGIN : undefined;

    return (
        <div className={className} style={{height: blockHeight}}>
            {children}
        </div>
    );
};

export default DrawerContainer;
