import React, {ReactNode} from 'react';

import {ECalendarType} from 'components/Calendar/types';

import Button, {IButtonProps} from 'components/Button/Button';

import cx from './DatePickerFooter.scss';

export interface IDatePickerFooterProps {
    visible?: boolean;

    messageNode?: ReactNode;

    buttonDisabled?: boolean;
    buttonText?: string;
    showButton?: boolean;
    onButtonClick?: IButtonProps['onClick'];
}

export interface IDatePickerFooterPropsByCalendarType {
    [ECalendarType.StartDate]?: Omit<IDatePickerFooterProps, 'onButtonClick'>;
    [ECalendarType.EndDate]?: Omit<IDatePickerFooterProps, 'onButtonClick'>;
}

const DatePickerFooter: React.FC<IDatePickerFooterProps> = ({
    buttonText,
    showButton,
    buttonDisabled,
    onButtonClick,
    messageNode,
    visible,
}) => {
    if (!visible) {
        return null;
    }

    return (
        <div className={cx('container')}>
            {messageNode && <div className={cx('message')}>{messageNode}</div>}

            {showButton && (
                <Button
                    width="max"
                    theme="primary"
                    size="l"
                    disabled={buttonDisabled}
                    onClick={onButtonClick}
                >
                    {buttonText}
                </Button>
            )}
        </div>
    );
};

export default DatePickerFooter;
