import {useCallback, useState} from 'react';

import {EBusesGoal} from 'utilities/metrika/types/goals/buses';
import {EAviaGoal} from 'utilities/metrika/types/goals/avia';
import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {reachGoal} from 'utilities/metrika';

type TGoals =
    | typeof EAviaGoal
    | typeof ETrainsGoal
    | typeof EHotelsGoal
    | typeof EBusesGoal;

type TMetricsCallbacks = {
    reachCalendarInteraction: () => void;
    reachSearchInteraction: () => void;
};

const useCalendarConversionExpMetrics = (goals: TGoals): TMetricsCallbacks => {
    const [interacted, setInteracted] = useState(false);

    const reachCalendarInteraction = useCallback(() => {
        if (!interacted) {
            setInteracted(true);
        }

        reachGoal(goals.CALENDAREXP_CALENDAR_INTERACTION);
    }, [interacted, goals]);

    const reachSearchInteraction = useCallback(() => {
        if (!interacted) {
            return;
        }

        reachGoal(goals.CALENDAREXP_SEARCH_CLICKED_AFTER_INTERACTION);
    }, [interacted, goals]);

    return {reachCalendarInteraction, reachSearchInteraction};
};

export default useCalendarConversionExpMetrics;
