import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import Separator from 'components/Separator/Separator';

import cx from './DepartureAndArrivalInfo.scss';

interface IDepartureAndArrivalInfoProps
    extends IWithQaAttributes,
        IWithClassName {
    fromTime: React.ReactNode;
    fromTimeTopDescription?: React.ReactNode;
    fromTimeBottomDescription?: React.ReactNode;
    toTime: React.ReactNode;
    toTimeTopDescription?: React.ReactNode;
    toTimeBottomDescription?: React.ReactNode;
    duration: React.ReactNode;
    durationTopDescription?: React.ReactNode;
    durationBottomDescription?: React.ReactNode;
    footer?: React.ReactNode;
}

const DepartureAndArrivalInfo: React.FC<IDepartureAndArrivalInfoProps> =
    props => {
        const {
            className,
            fromTimeTopDescription,
            durationTopDescription,
            toTimeTopDescription,
            fromTime,
            duration,
            toTime,
            footer,
            fromTimeBottomDescription,
            durationBottomDescription,
            toTimeBottomDescription,
        } = props;

        return (
            <div className={className} {...prepareQaAttributes(props)}>
                <Flex alignItems="flex-end">
                    <div
                        className={cx('fromTimeTopDescription')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'fromTimeTopDescription',
                        })}
                    >
                        {fromTimeTopDescription}
                    </div>
                    <div
                        className={cx('durationTopDescription')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'durationTopDescription',
                        })}
                    >
                        {durationTopDescription}
                    </div>
                    <div
                        className={cx('toTimeTopDescription')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'toTimeTopDescription',
                        })}
                    >
                        {toTimeTopDescription}
                    </div>
                </Flex>

                <Flex alignItems="center">
                    <div
                        className={cx('fromTime')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'fromTime',
                        })}
                    >
                        {fromTime}
                    </div>

                    <Separator className={cx('separator')} />

                    <div
                        className={cx('duration')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'duration',
                        })}
                    >
                        {duration}
                    </div>

                    <Separator className={cx('separator')} />

                    <div
                        className={cx('toTime')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'toTime',
                        })}
                    >
                        {toTime}
                    </div>
                </Flex>

                <Flex alignItems="baseline" above="1">
                    <div
                        className={cx('fromTimeBottomDescription')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'fromTimeBottomDescription',
                        })}
                    >
                        {fromTimeBottomDescription}
                    </div>
                    <div
                        className={cx('durationBottomDescription')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'durationBottomDescription',
                        })}
                    >
                        {durationBottomDescription}
                        <Flex
                            className={cx('footer')}
                            alignItems="baseline"
                            justifyContent="center"
                        >
                            {footer}
                        </Flex>
                    </div>
                    <div
                        className={cx('toTimeBottomDescription')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'toTimeBottomDescription',
                        })}
                    >
                        {toTimeBottomDescription}
                    </div>
                </Flex>
            </div>
        );
    };

export default React.memo(DepartureAndArrivalInfo);
