import {ReactElement, ComponentType} from 'react';
import {Subtract} from 'utility-types';

import {IWithDeviceType} from 'types/withDeviceType';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

export interface IDeviceTypeProvider extends IWithDeviceType {}

function DeviceTypeProvider<TProps extends IDeviceTypeProvider>(
    WrappedComponent: ComponentType<TProps>,
) {
    function DeviceType(
        props: Subtract<TProps, IDeviceTypeProvider>,
    ): ReactElement {
        const deviceType = useDeviceType();

        return (
            <WrappedComponent {...(props as TProps)} deviceType={deviceType} />
        );
    }

    return DeviceType;
}

export default DeviceTypeProvider;
