import React from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import DotSeparator from './DotSeparator';

export default {
    title: 'Example/DotSeparator',
    component: DotSeparator,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <div>
        {['банан', 'дыня', 'ананас'].map(item => (
            <React.Fragment key={item}>
                {item}
                <DotSeparator />
            </React.Fragment>
        ))}
    </div>
);
Simple.parameters = {
    info: {
        title: 'DotSeparator',
        comment: (
            <>
                Разделитель точка с двумя пробелами.
                <br />
                Последний разделитель в списке детей скрывается автоматически.
            </>
        ),
    },
};
