import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    CHAR_LIST_MARKER,
    CHAR_NBSP,
    CHAR_SPACE,
} from 'utilities/strings/charCodes';

import cx from './DotSeparator.scss';

interface IDotSeparatorProps extends IWithClassName {}

const SPACE_COUNT = 2;

const DotSeparator: React.FC<IDotSeparatorProps> = ({className}) => {
    const before = CHAR_NBSP.repeat(SPACE_COUNT);
    const after = CHAR_SPACE.repeat(SPACE_COUNT);

    return (
        <span className={cx(className, 'root')}>
            {`${before}${CHAR_LIST_MARKER}${after}`}
        </span>
    );
};

export default DotSeparator;
