import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Card from 'components/Card/Card';
import {Center} from 'projects/avia/components/Center/Center';
import NoTicketsM from 'icons/illustrations/NoTicketsRed/NoTicketsRedM';

import cx from './EmptySerp.scss';

export interface IEmptySerpProps extends IWithClassName, IWithQaAttributes {
    title: React.ReactNode;
    text: React.ReactNode;
    withIcon?: boolean;
    fullHeight?: boolean;
}

/**
 * Отображает информацию при пустой выдачи (0 вариантов от бэкэнда)
 */
const EmptySerp: React.FC<IEmptySerpProps> = props => {
    const {title, text, className, withIcon, fullHeight} = props;

    const deviceType = useDeviceType();

    const emptySerpBlock = (
        <Center className={cx('description')}>
            {withIcon && (
                <NoTicketsM
                    className={cx('icon')}
                    width={deviceType.isMobile ? 134 : 200}
                    height={deviceType.isMobile ? 134 : 200}
                />
            )}

            <h1
                className={cx('description__title')}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'emptySerp-title',
                })}
            >
                {title}
            </h1>
            <div
                className={cx('description__text')}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'emptySerp-text',
                })}
            >
                {text}
            </div>
        </Center>
    );

    if (deviceType.isMobile) {
        return (
            <div
                className={cx(
                    'root',
                    deviceMods('root', deviceType),
                    fullHeight && 'fullHeight',
                    className,
                )}
                {...prepareQaAttributes(props)}
            >
                {emptySerpBlock}
            </div>
        );
    }

    return (
        <Card
            className={cx(
                'root',
                deviceMods('root', deviceType),
                fullHeight && 'fullHeight',
                className,
            )}
            shadow="default"
            x="8"
            y="8"
            {...prepareQaAttributes(props)}
        >
            {emptySerpBlock}
        </Card>
    );
};

export default EmptySerp;
