import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import Button from 'components/Button/Button';
import TicketCatM from 'icons/illustrations/TicketCat/TicketCatM';

import ErrorModal from './ErrorModal';

export default {
    title: 'Example/ErrorModal',
    component: ErrorModal,
} as Meta;

const title = 'The cactus';
const text =
    "The most notable thing about Time is that it is so purely relative. A large amount of reminiscence is, by common consent, conceded to the drowning man; and it is not past belief that one may review an entire courtship while removing one's gloves.";

export const Simple: TStorybookFunctionComponent = () => {
    const [visibleSingle, setVisibleSingle] = useState(false);
    const [visiblePair, setVisiblePair] = useState(false);
    const [visibleDiffPair, setVisibleDiffPair] = useState(false);
    const [visibleLink, setVisibleLink] = useState(false);
    const [visibleImage, setVisibleImage] = useState(false);
    const [visibleMax, setVisibleMax] = useState(false);
    const [visibleTextContent, setVisibleTextContent] = useState(false);
    const [visibleWholeContent, setVisibleWholeContent] = useState(false);

    return (
        <>
            <Box inline between="2">
                <Button onClick={(): void => setVisibleSingle(true)}>
                    Одна кнопка
                </Button>
                <Button onClick={(): void => setVisiblePair(true)}>
                    Две кнопки
                </Button>
                <Button onClick={(): void => setVisibleDiffPair(true)}>
                    Две кнопки разной ширины
                </Button>
                <Button onClick={(): void => setVisibleLink(true)}>
                    Ссылка
                </Button>
                <Button onClick={(): void => setVisibleImage(true)}>
                    С картинкой
                </Button>
                <Button onClick={(): void => setVisibleMax(true)}>
                    Максимум
                </Button>
                <Button onClick={(): void => setVisibleTextContent(true)}>
                    С JSX контентом
                </Button>
                <Button onClick={(): void => setVisibleWholeContent(true)}>
                    Со всеми полями
                </Button>
            </Box>

            <ErrorModal
                title={title}
                text={text}
                isVisible={visibleSingle}
                primaryAction={{
                    title: 'Buy book',
                    type: 'button',
                    handler: (): void => setVisibleSingle(false),
                }}
            />

            <ErrorModal
                title={title}
                text={text}
                isVisible={visiblePair}
                primaryAction={{
                    title: 'Buy book',
                    type: 'button',
                    handler: (): void => setVisiblePair(false),
                }}
                secondaryAction={{
                    title: 'Close book',
                    type: 'button',
                    handler: (): void => setVisiblePair(false),
                }}
            />

            <ErrorModal
                title={title}
                text={text}
                isVisible={visibleDiffPair}
                primaryAction={{
                    title: 'Buy book',
                    type: 'button',
                    handler: (): void => setVisibleDiffPair(false),
                }}
                secondaryAction={{
                    title: 'Close book',
                    type: 'button',
                    handler: (): void => setVisibleDiffPair(false),
                }}
            />

            <ErrorModal
                title={title}
                text={text}
                isVisible={visibleLink}
                primaryAction={{
                    title: 'Buy book',
                    type: 'button',
                    handler: (): void => setVisibleLink(false),
                }}
                secondaryAction={{
                    title: 'Close book',
                    type: 'button',
                    handler: (): void => setVisibleLink(false),
                }}
                link={{
                    text: 'online book store',
                    url: '#',
                }}
            />

            <ErrorModal
                title={title}
                text={text}
                isVisible={visibleImage}
                primaryAction={{
                    title: 'Buy book',
                    type: 'button',
                    handler: (): void => setVisibleImage(false),
                }}
                image={<TicketCatM width={160} height={160} />}
            />

            <ErrorModal
                title={title}
                text={text}
                isVisible={visibleMax}
                primaryAction={{
                    title: 'Buy book',
                    type: 'button',
                    handler: (): void => setVisibleMax(false),
                }}
                secondaryAction={{
                    title: 'Close book',
                    type: 'button',
                    handler: (): void => setVisibleMax(false),
                }}
                link={{
                    text: 'online book store',
                    url: '#',
                }}
                image={<TicketCatM width={160} height={160} />}
            />

            <ErrorModal
                title={title}
                isVisible={visibleTextContent}
                primaryAction={{
                    title: 'Buy book',
                    type: 'button',
                    handler: (): void => setVisibleTextContent(false),
                }}
            >
                <div
                    style={{
                        border: '1px solid coral',
                        padding: '20px',
                        color: 'darkgreen',
                    }}
                >
                    {text}
                </div>
            </ErrorModal>

            <ErrorModal
                title={title}
                text={text}
                isVisible={visibleWholeContent}
                primaryAction={{
                    title: 'Buy book',
                    type: 'button',
                    handler: (): void => setVisibleWholeContent(false),
                }}
                secondaryAction={{
                    title: 'Close book',
                    type: 'button',
                    handler: (): void => setVisibleWholeContent(false),
                }}
                link={{
                    text: 'online book store',
                    url: '#',
                }}
                image={<TicketCatM width={160} height={160} />}
            >
                <div
                    style={{
                        border: '1px solid coral',
                        padding: '20px',
                        color: 'darkgreen',
                    }}
                >
                    {text}
                </div>
            </ErrorModal>
        </>
    );
};
