import {times} from 'lodash';
import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import FeaturedDirections from './FeaturedDirections';

export default {
    title: 'Example/FeaturedDirections',
    component: FeaturedDirections,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    return (
        <FeaturedDirections
            title="Общий заголовок"
            items={[
                ...times(15, i => ({
                    text: `Текст элемента ${i} без цены`,
                    url: '',
                    price:
                        Math.random() > 0.5
                            ? {
                                  value: 100,
                                  currency: CurrencyType.RUB,
                              }
                            : undefined,
                })),
            ]}
        />
    );
};

export const ManyItems: TStorybookFunctionComponent = () => {
    return (
        <FeaturedDirections
            title="Общий заголовок"
            items={[
                ...times(30, i => ({
                    text: `Текст элемента ${i} без цены`,
                    url: '',
                    price:
                        Math.random() > 0.5
                            ? {
                                  value: 100,
                                  currency: CurrencyType.RUB,
                              }
                            : undefined,
                })),
            ]}
        />
    );
};
