import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Text, {TTextColor, TTextSize, TTextWeight} from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import {TBoxSizes} from 'components/Box/Box';

import cx from './FieldLabel.scss';

interface IFieldProps extends IWithClassName, IWithQaAttributes {
    label: string;
    labelSize?: TTextSize;
    labelColor?: TTextColor;
    valueSize?: TTextSize;
    valueWeight?: TTextWeight;
    between?: TBoxSizes;
    children: React.ReactNode;
}

const FieldLabel: React.FC<IFieldProps> = props => {
    const {
        className,
        label,
        labelSize = 's',
        labelColor = 'secondary',
        valueSize = 'm',
        valueWeight,
        between,
        children,
    } = props;

    return (
        <Flex
            className={className}
            flexDirection="column"
            between={between}
            {...prepareQaAttributes(props)}
        >
            <Text
                size={labelSize}
                color={labelColor}
                {...prepareQaAttributes({parent: props, current: 'label'})}
            >
                {label}
            </Text>
            <Text
                className={cx('value')}
                size={valueSize}
                weight={valueWeight}
                {...prepareQaAttributes({parent: props, current: 'value'})}
            >
                {children}
            </Text>
        </Flex>
    );
};

export default FieldLabel;
