import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';

import FiltersAndSortsMobile from './FiltersAndSortsMobile';

export default {
    title: 'Example/FiltersAndSortsMobile',
    component: FiltersAndSortsMobile,
    decorators: [routerDecorator],
} as Meta;

export const WideButton: TStorybookFunctionComponent = () => (
    <Box between="2">
        <FiltersAndSortsMobile
            itemsCount={10}
            activeFiltersCount={0}
            isCompact={false}
            onApply={(): void => console.log('Apply')}
            onReset={(): void => console.log('Reset')}
        >
            {null}
        </FiltersAndSortsMobile>
        <FiltersAndSortsMobile
            itemsCount={10}
            activeFiltersCount={3}
            isCompact={false}
            onApply={(): void => console.log('Apply')}
            onReset={(): void => console.log('Reset')}
        >
            {null}
        </FiltersAndSortsMobile>
    </Box>
);
WideButton.parameters = {
    info: {
        title: 'Широкая кнопка с активными фильтрами и без',
    },
};

export const NarrowButton: TStorybookFunctionComponent = () => (
    <Box between="2">
        <div>
            <FiltersAndSortsMobile
                itemsCount={10}
                activeFiltersCount={0}
                isCompact
                onApply={(): void => console.log('Apply')}
                onReset={(): void => console.log('Reset')}
            >
                {null}
            </FiltersAndSortsMobile>
        </div>
        <div>
            <FiltersAndSortsMobile
                itemsCount={10}
                activeFiltersCount={3}
                isCompact
                onApply={(): void => console.log('Apply')}
                onReset={(): void => console.log('Reset')}
            >
                {null}
            </FiltersAndSortsMobile>
        </div>
    </Box>
);
NarrowButton.parameters = {
    info: {
        title: 'Узкая кнопка',
    },
};
