import React, {RefObject} from 'react';

import BottomSheet, {
    IBottomSheetProps,
} from 'components/BottomSheet/BottomSheet';
import FilterHeader from './components/FilterHeader/FilterHeader';
import FilterFooter from './components/FilterFooter/FilterFooter';

import cx from './FiltersBottomSheet.scss';

interface IFiltersBottomSheetProps {
    isOpened: boolean;
    onClose: IBottomSheetProps['onClose'];

    header: string;
    onReset?: () => void;
    showResetButton?: boolean;
    resetButtonDisabled: boolean;

    submitLabel: string;
    onSubmit: () => void;
    submitButtonDisabled: boolean;

    outerSheetRef?: RefObject<HTMLDivElement>;

    maxSize?: string;

    contentPadding?: 'normal' | 'none';
}

const FiltersBottomSheet: React.FC<IFiltersBottomSheetProps> = ({
    onClose,
    resetButtonDisabled,
    header,
    onReset,
    children,
    submitLabel,
    onSubmit,
    submitButtonDisabled,
    isOpened,
    outerSheetRef,
    maxSize,
    contentPadding = 'normal',
    showResetButton,
}) => {
    return (
        <BottomSheet
            isOpened={isOpened}
            onClose={onClose}
            paddingTopSpace={0}
            paddingBottomSpace={0}
            innerRef={outerSheetRef}
            maxSize={maxSize}
            padding={0}
        >
            <FilterHeader
                label={header}
                buttonResetDisabled={resetButtonDisabled}
                onReset={onReset}
                showResetButton={showResetButton}
            />

            <div className={cx('content', `content_padding-${contentPadding}`)}>
                {children}
            </div>

            <FilterFooter
                disabled={submitButtonDisabled}
                onClick={onSubmit}
                label={submitLabel}
            />
        </BottomSheet>
    );
};

export default FiltersBottomSheet;
