import React from 'react';

import {Android, IOS} from 'utilities/deviceType/constants';

import {isOS} from 'utilities/deviceType/isOS';
import isMobileFirefox from 'utilities/deviceType/isMobileFirefox';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Button from 'components/Button/Button';

import cx from './FilterFooter.scss';

interface IFilterFooterProps {
    disabled: boolean;
    onClick: () => void;
    label: string;
}

const FilterFooter: React.FC<IFilterFooterProps> = ({
    disabled,
    onClick,
    label,
}) => {
    const {os, browser} = useDeviceType();

    return (
        <div
            className={cx('footer', {
                footer_IOS: isOS(os, IOS),
                footer_static: isOS(os, Android) && isMobileFirefox(browser),
            })}
        >
            <Button
                width="max"
                theme="primary"
                size="l"
                disabled={disabled}
                onClick={onClick}
            >
                {label}
            </Button>
        </div>
    );
};

export default FilterFooter;
