import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/common-filters';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import LinkButton from 'components/LinkButton/LinkButton';

import cx from './FilterHeader.scss';

interface IFilterHeaderProps {
    label: string;
    showResetButton?: boolean;
    buttonResetDisabled?: boolean;
    onReset?: () => void;
}

const FilterHeader: React.FC<IFilterHeaderProps> = ({
    label,
    buttonResetDisabled,
    onReset,
    showResetButton = true,
}) => {
    const deviceType = useDeviceType();

    return (
        <Flex
            className={cx('header', deviceMods('header', deviceType))}
            justifyContent="space-between"
        >
            <Text
                whiteSpace={deviceType.isDesktop ? 'nowrap' : 'normal'}
                size="l"
                weight="bold"
            >
                {label}
            </Text>
            {showResetButton && (
                <LinkButton
                    className={cx(
                        'buttonReset',
                        buttonResetDisabled && 'buttonReset_disabled',
                    )}
                    disabled={buttonResetDisabled}
                    onClick={onReset}
                >
                    {i18nBlock.reset()}
                </LinkButton>
            )}
        </Flex>
    );
};

export default FilterHeader;
