import React from 'react';

import Box from 'components/Box/Box';
import HorizontalScroller from 'components/HorizontalScroller/HorizontalScroller';

import cx from './QuickFiltersPadder.scss';

interface IQuickFiltersPadderProps {
    padding?: 'none' | 'normal';
}

const QuickFiltersPadder: React.FC<IQuickFiltersPadderProps> = ({
    children,
    padding = 'normal',
}) => (
    <Box below={5} className={cx('root', `root_padding-${padding}`)}>
        <HorizontalScroller padderClassName={cx('container')} offset={4}>
            {children}
        </HorizontalScroller>
    </Box>
);

export default QuickFiltersPadder;
