import {ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useBoolean} from 'utilities/hooks/useBoolean';

import Button from 'components/Button/Button';
import DropdownFilter from 'components/DropdownFilter/DropdownFilter';
import FilterCheckList from 'components/FilterCheckList/FilterCheckList';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

import FiltersDesktop from './FiltersDesktop';

export default {
    title: 'Example/FiltersDesktop',
    component: FiltersDesktop,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const {
        value: canReset,
        setTrue: enableReset,
        setFalse: disableReset,
    } = useBoolean(false);

    return (
        <FiltersDesktop
            skeletonsWidth={[80, 80, 80]}
            canReset={canReset}
            onReset={disableReset}
        >
            <DropdownFilter label="Filter 1">
                <div style={{background: 'pink', width: 320, height: 600}}>
                    scroll me
                </div>
            </DropdownFilter>
            <DropdownFilter label="Filter 2" checked={canReset}>
                <Button onClick={enableReset}>click me</Button>
            </DropdownFilter>
            <DropdownFilter label="Filter 3">
                <DeviceTypeContext.Consumer>
                    {(deviceType): ReactNode => (
                        <FilterCheckList
                            options={['день', 'ночь', 'утро', 'вечер']}
                            availableValues={['ночь', 'утро', 'вечер']}
                            values={['день']}
                            deviceType={deviceType}
                            onChange={noop}
                        />
                    )}
                </DeviceTypeContext.Consumer>
            </DropdownFilter>
        </FiltersDesktop>
    );
};

Simple.parameters = {
    info: {
        title: 'Панель фильтров в десктопе',
    },
};

export const Skeletons: TStorybookFunctionComponent = () => (
    <FiltersDesktop
        canReset
        loading
        onReset={noop}
        skeletonsWidth={[90, 200, 200]}
    >
        <div />
        <div />
        <div />
    </FiltersDesktop>
);
Skeletons.parameters = {
    info: {
        title: 'Скелетоны встроены, количество и ширина скелетонов задается через skeletonsWidth',
    },
};
