import React from 'react';

import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

interface IFilterDesktopSkeletonProps {
    skeletonsWidth: number[];
}

const FiltersDesktopSkeleton: React.FC<IFilterDesktopSkeletonProps> = ({
    skeletonsWidth,
}) => {
    return (
        <>
            {skeletonsWidth.map((width, i) => {
                return <ButtonSkeleton key={i} style={{width}} />;
            })}
        </>
    );
};

export default FiltersDesktopSkeleton;
