import React, {useMemo} from 'react';

import {TLD_PLACEHOLDER} from 'components/Footer/constants/footerLinks';

import {IFooterLink} from 'components/Footer/types';

import {useTld} from 'utilities/hooks/useTld';
import {reachGoal} from 'utilities/metrika';

import Link from 'components/Link/Link';
import Flex, {IFlexProps} from 'components/Flex/Flex';

import cx from './FooterLinks.scss';

interface IFooterLinksProps {
    type: 'vertical' | 'horizontal';
    links: IFooterLink[];
}

const FooterLinks: React.FC<IFooterLinksProps> = props => {
    const {type, links} = props;
    const tld = useTld();

    const flexProps = useMemo((): IFlexProps => {
        if (type === 'vertical') {
            return {flexDirection: 'column', between: 3};
        }

        return {
            flexDirection: 'row',
            between: 5,
            inline: true,
        };
    }, [type]);

    return (
        <div>
            <Flex className={cx('links', `links_${type}`)} {...flexProps}>
                {links.map(({icon, link, name, metrikaId}) => (
                    <Link
                        className={cx('link')}
                        key={link}
                        url={link.replace(TLD_PLACEHOLDER, tld)}
                        theme="black"
                        target="_blank"
                        rel="noopener noreferrer"
                        onClick={
                            metrikaId
                                ? (): void => reachGoal(metrikaId)
                                : undefined
                        }
                    >
                        {icon ? (
                            <Flex flexDirection="row" inline between={2}>
                                {icon}
                                <span>{name}</span>
                            </Flex>
                        ) : (
                            name
                        )}
                    </Link>
                ))}
            </Flex>
        </div>
    );
};

export default FooterLinks;
