import React from 'react';

import Link from 'components/Link/Link';
import Flex from 'components/Flex/Flex';
import SocMediaTelegram from 'icons/illustrations/SocMedia/SocMediaTelegram';
import SocMediaTwitter from 'icons/illustrations/SocMedia/SocMediaTwitter';
import SocMediaVK from 'icons/illustrations/SocMedia/SocMediaVK';
import SocMediaZen from 'icons/illustrations/SocMedia/SocMediaZen';

const SocialLinks: React.FC = () => {
    const width = 32;
    const height = 32;

    return (
        <Flex inline between={2}>
            <Link
                url="https://vk.com/travel.yandex"
                target="_blank"
                rel="noopener noreferrer"
            >
                <SocMediaVK width={width} height={height} />
            </Link>

            <Link
                url="https://t.me/yandex_travel"
                target="_blank"
                rel="noopener noreferrer"
            >
                <SocMediaTelegram width={width} height={height} />
            </Link>

            <Link
                url="https://zen.yandex.ru/yandextravel"
                target="_blank"
                rel="noopener noreferrer"
            >
                <SocMediaZen width={width} height={height} />
            </Link>

            <Link
                url="https://twitter.com/yandextravel"
                target="_blank"
                rel="noopener noreferrer"
            >
                <SocMediaTwitter width={width} height={height} />
            </Link>
        </Flex>
    );
};

export default SocialLinks;
