import {EProjectName} from 'constants/common';
import {
    BUSES_BOOKING_CONDITIONS_LINK,
    COMMON_AFFILIATES_LINK,
    COMMON_AGREEMENT_LINK,
    COMMON_FEEDBACK_LINK,
    COMMON_HELP_LINK,
    COMMON_PARTNERS_LINK,
    COMMON_PLUS_LOYALTY,
    HOTELS_BOOKING_CONDITIONS_LINK,
    HOTELS_NEW_OBJECT_LINK,
    TRAINS_CONDITIONS_LINK,
} from 'components/Footer/constants/footerLinks';

import {EFooterProject, IFooterLink} from 'components/Footer/types';

export const PROJECT_FOOTER_TYPES: PartialRecord<EProjectName, EFooterProject> =
    {
        [EProjectName.ACCOUNT]: EFooterProject.ACCOUNT,
        [EProjectName.AVIA]: EFooterProject.AVIA,
        [EProjectName.TRAINS]: EFooterProject.TRAINS,
        [EProjectName.HOTELS]: EFooterProject.HOTELS,
        [EProjectName.BUSES]: EFooterProject.BUSES,
        [EProjectName.TOURS]: EFooterProject.TOURS,
        [EProjectName.WHITE_LABEL]: EFooterProject.WHITE_LABEL,
    };

const FOOTER_MENU_ITEMS: Record<EFooterProject, IFooterLink[]> = {
    [EFooterProject.AVIA]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.TRAINS]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        TRAINS_CONDITIONS_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.HOTELS]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        HOTELS_NEW_OBJECT_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.HOTELS_BOOKING]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        HOTELS_NEW_OBJECT_LINK,
        HOTELS_BOOKING_CONDITIONS_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.ACCOUNT]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.ACCOUNT_TRAINS]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        TRAINS_CONDITIONS_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.BUSES]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        BUSES_BOOKING_CONDITIONS_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.TRIPS]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.TOURS]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.WHITE_LABEL]: [
        COMMON_PARTNERS_LINK,
        HOTELS_NEW_OBJECT_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
        COMMON_AFFILIATES_LINK,
    ],
};

const DEFAULT_FOOTER_MENU_ITEMS = [
    COMMON_HELP_LINK,
    COMMON_FEEDBACK_LINK,
    COMMON_AGREEMENT_LINK,
];

export default function getMenuItems({
    footerType,
    withPlus = true,
}: {
    footerType: EFooterProject | undefined;
    withPlus?: boolean;
}): IFooterLink[] {
    const plusItems = withPlus ? [COMMON_PLUS_LOYALTY] : [];

    if (!footerType) {
        return DEFAULT_FOOTER_MENU_ITEMS.concat(plusItems);
    }

    return (FOOTER_MENU_ITEMS[footerType] ?? DEFAULT_FOOTER_MENU_ITEMS).concat(
        plusItems,
    );
}
