import {URLs} from 'constants/urls';

import {IFooterLink} from 'components/Footer/types';

import {internalUrl} from 'utilities/url';

import * as i18nBlock from 'i18n/components';

const serviceCrossLinks: IFooterLink[] = [
    {
        name: i18nBlock.footerDotServiceDotRaspDotLink(),
        link: 'https://rasp.yandex.ru/',
    },
    {
        name: i18nBlock.footerDotServiceDotJournalDotLink(),
        link: internalUrl(URLs.journalRoot, null, {
            withOrigin: true,
            trailingSlash: true,
        }),
    },
];

export default serviceCrossLinks;
