import {FunctionComponent, ReactNode} from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import {getUserInfo} from 'selectors/common/userInfoSelector';

import {EPassportMode, getPassportUrl} from 'utilities/url/getPassportUrl';
import getCommonCardProps from 'projects/hotels/components/ForceLogin/utilities/getCommonCardProps';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Card from 'components/Card/Card';
import BenefitIcon from 'icons/illustrations/Benefit/BenefitM';
import YaSignIcon from 'icons/illustrations/Touch/TouchLogoYaSign';
import PlusIcon from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientXL';
import ArrowRightIcon from 'icons/16/ArrowRight';
import Link from 'components/Link/Link';
import ForceLoginLayout from 'components/ForceLogin/ForceLoginLayout/ForceLoginLayout';

import cx from './ForceLoginAuthLink.scss';

const ILLUSTRATIONS = {
    benefit: BenefitIcon,
    plus: PlusIcon,
    yandex: YaSignIcon,
};

export interface IForceLoginAuthLinkProps extends IWithClassName {
    message: ReactNode;
    dropShadow?: boolean;
    image?: 'benefit' | 'plus' | 'yandex';
    onClick?: () => void;
}

const ForceLoginAuthLink: FunctionComponent<IForceLoginAuthLinkProps> = ({
    className,
    message,
    dropShadow,
    image = 'benefit',
    onClick,
}) => {
    const {passportPath} = useSelector(getUserInfo);
    const {isMobile} = useDeviceType();

    const Image = ILLUSTRATIONS[image];

    return (
        <Card
            className={className}
            onClick={onClick}
            {...getCommonCardProps({isMobile, dropShadow})}
        >
            <Link
                url={getPassportUrl({
                    mode: EPassportMode.AUTH,
                    passportHost: passportPath,
                    retpath: window.location.href,
                })}
            >
                <ForceLoginLayout
                    image={<Image className={cx('image')} />}
                    text={message}
                    icon={ArrowRightIcon}
                    hoverType="entire"
                />
            </Link>
        </Card>
    );
};

export default ForceLoginAuthLink;
