import {noop} from 'lodash';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import CloseIcon from 'icons/16/Close';
import Avatar from 'components/Avatar/Avatar';

import ForceLoginLayout from './ForceLoginLayout';

export default {
    title: 'Example/ForceLoginLayout',
    component: ForceLoginLayout,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <div style={{width: 400}}>
        <ForceLoginLayout
            image={
                <Avatar
                    src="https://avatars.mdst.yandex.net//get-yapic/0/0-0/islands-retina-middle"
                    size="m"
                />
            }
            text="Добрый день, <username>. Специально для вас мы снизили цены."
            icon={CloseIcon}
            onIconClick={noop}
            hoverType="icon"
        />
    </div>
);
