import {ComponentType, FunctionComponent, ReactNode} from 'react';

import {IIconProps} from 'icons/types/icon';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Text from 'components/Text/Text';

import cx from './ForceLoginLayout.scss';

interface IForceLoginLayoutProps {
    image: ReactNode;
    imageClassName?: string;
    text: ReactNode;
    icon: ComponentType<IIconProps>;
    onIconClick?: () => void;
    hoverType: 'icon' | 'entire';
}

const ForceLoginLayout: FunctionComponent<IForceLoginLayoutProps> = ({
    image,
    imageClassName,
    text,
    icon: Icon,
    onIconClick,
    hoverType,
}) => {
    const deviceType = useDeviceType();

    return (
        <div
            className={cx(
                'root',
                `root_hoverType_${hoverType}`,
                deviceMods('root', deviceType),
            )}
        >
            <div className={cx('image', imageClassName)}>{image}</div>
            <Text className={cx('text')} size="m">
                {text}
            </Text>
            <div className={cx('icon')} onClick={onIconClick}>
                <Icon />
            </div>
        </div>
    );
};

export default ForceLoginLayout;
