import {useContext, useMemo} from 'react';
import {useFormState} from 'react-final-form';
import _get from 'lodash/get';

import {isNotNullable} from 'types/utilities';

import {FieldGroupContext} from 'components/Form/components/FieldGroup/FieldGroup';

/**
 * @param fieldName - имя поля, если не передать параметр то вернет группу значений формы на основе значения из FieldGroupContext
 * @param fieldGroupId - по умолчанию подставляет значение из FieldGroupContext
 */
export function useFieldValue<T>(
    fieldName?: string,
    fieldGroupId?: string,
): T | undefined {
    const {values} = useFormState({subscription: {values: true}});
    const contextFormGroupId = useContext(FieldGroupContext);
    const formGroupId = fieldGroupId || contextFormGroupId;

    const value = useMemo(() => {
        const fieldPathArray = [formGroupId, fieldName].filter(isNotNullable);

        return _get(values, fieldPathArray.join('.'));
    }, [values, formGroupId, fieldName]);

    return value;
}
