import {getIn} from 'final-form';
import {getFormInputs} from 'final-form-focus';

function findInput(
    inputs: HTMLInputElement[],
    errors: object,
): HTMLInputElement | undefined {
    return inputs.find(input => {
        const name = input.dataset.name || input.name;

        return name && getIn(errors, name);
    });
}

function scrollToField(field: HTMLElement): void {
    const headerOffset = 45;
    const fieldPosition = field.getBoundingClientRect().top;
    const offsetPosition = fieldPosition - headerOffset;

    if (window.scrollBy) {
        window.scrollBy({top: offsetPosition});
    }
}

function isMobileSafari(): boolean {
    return Boolean(
        navigator.userAgent.match(/(iPod|iPhone|iPad)/) &&
            navigator.userAgent.match(/AppleWebKit/),
    );
}

export type TFocusFirstInvalidField<T extends object = object> = (
    formName: string,
    errors: T,
) => void;

function focusFirstInvalidField<T extends object = object>(
    args: [string, T],
): void {
    const [formName, errors] = args;
    const formInputs = getFormInputs(formName)() as HTMLInputElement[];
    const field = findInput(formInputs, errors);

    if (field) {
        // Safari bug: на ios с какой-то из 13 версий, фокус перестал скролить к элементу, если это не input
        // Поэтому делаем программный скролл, пока эплы не починят
        // TODO: проверить не починили ли, если да - то просто убрать scrollToField
        if (isMobileSafari() && !(field instanceof HTMLInputElement)) {
            scrollToField(field);
        }

        field.focus();
    }
}

export default focusFirstInvalidField;
