import {MutableState, ValidationErrors} from 'final-form';
import flat from 'flat';

export type TSetFormErrors = (errors: ValidationErrors) => void;

function setFormErrors<T>(
    args: [ValidationErrors],
    state: MutableState<T>,
): void {
    const [errors] = args;
    const flattenErrors = flat<ValidationErrors, object>(errors);

    Object.entries(flattenErrors).forEach(([fieldName, fieldError]) => {
        const field = state.fields[fieldName];

        if (field) {
            field.data = {
                ...field.data,
                error: {
                    value: field.lastFieldState?.value,
                    message: fieldError,
                },
            };
        }
    });
}

export default setFormErrors;
