import {ValidationErrors, SubmissionErrors} from 'final-form';
import _merge from 'lodash/merge';

/**
 * Объединяет ошибки валидации
 *
 * @param errors - ошибки валидации с более высоким приоритетом
 * @param newErrors - ошибки валидации с более низкий приоритетом
 */
function mergeErrors(
    errors: ValidationErrors,
    newErrors?: ValidationErrors | SubmissionErrors | void,
): void {
    if (newErrors) {
        _merge(errors, newErrors);
    }
}

export default mergeErrors;
