import {ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import Form from 'components/Form/Form';
import Input from 'components/Input/Input';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

import FormField from './FormField';

export default {
    title: 'Example/FormField',
    component: FormField,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <DeviceTypeContext.Consumer>
        {(deviceType): ReactNode => (
            <Form onSubmit={noop}>
                {({handleSubmit}): ReactNode => (
                    <form onSubmit={handleSubmit}>
                        <FormField
                            title="Заголовок поля"
                            name="name"
                            validate={(
                                value: string | undefined,
                            ): string | undefined =>
                                value && /^[A-z]*$/.test(value)
                                    ? undefined
                                    : 'латиницу жеж'
                            }
                            control={(
                                {input},
                                {error, inputRef, controlRef},
                            ): ReactNode => (
                                <Input
                                    {...input}
                                    inputRef={(currentInputRef): void => {
                                        inputRef.current = currentInputRef;
                                    }}
                                    innerRef={controlRef}
                                    placeholder="Вводите только латиницу"
                                    state={error ? 'error' : undefined}
                                />
                            )}
                            deviceType={deviceType}
                        />
                    </form>
                )}
            </Form>
        )}
    </DeviceTypeContext.Consumer>
);
